class SendMoneyHistoryResponseModel {
  SendMoneyHistoryResponseModel({
      String? status, 
      MainModel? mainModel,}){
    _status = status;
    _mainModel = mainModel;
}

  SendMoneyHistoryResponseModel.fromJson(dynamic json) {
    _status = json['status'].toString();
    _mainModel = json['data'] != null ? MainModel.fromJson(json['data']) : null;
  }
  String? _status;
  MainModel? _mainModel;

  String? get status => _status;
  MainModel? get mainModel => _mainModel;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['status'] = _status;
    if (_mainModel != null) {
      map['data'] = _mainModel?.toJson();
    }
    return map;
  }

}

class MainModel {
  MainModel({
      Transfers? transfers,}){
    _transfers = transfers;
}

  MainModel.fromJson(dynamic json) {
    _transfers = json['transfers'] != null ? Transfers.fromJson(json['transfers']) : null;
  }
  Transfers? _transfers;

  Transfers? get transfers => _transfers;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_transfers != null) {
      map['transfers'] = _transfers?.toJson();
    }
    return map;
  }

}

class Transfers {
  Transfers({
      List<Data>? data,
      String? nextPageUrl,
      }){
    _data = data;
    _nextPageUrl = nextPageUrl;
}

  Transfers.fromJson(dynamic json) {
    if (json['data'] != null) {
      _data = [];
      json['data'].forEach((v) {
        _data?.add(Data.fromJson(v));
      });
    }
    _nextPageUrl = json['next_page_url'];
  }

  List<Data>? _data;
  String? _nextPageUrl;

  List<Data>? get data => _data;
  String? get nextPageUrl => _nextPageUrl;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_data != null) {
      map['data'] = _data?.map((v) => v.toJson()).toList();
    }
    map['next_page_url'] = _nextPageUrl;
    return map;
  }

}


class Data {
  Data({
      int? id, 
      String? mtcnNumber, 
      String? trx, 
      String? countryDeliveryMethodId, 
      String? serviceId, 
      String? userId, 
      String? agentId, 
      dynamic serviceFormData, 
      String? baseCurrencyAmount, 
      String? baseCurrencyCharge, 
      String? sendingCountryId, 
      String? sendingCurrency, 
      String? sendingAmount, 
      String? sendingCharge, 
      String? recipientCountryId, 
      String? recipientCurrency, 
      String? recipientAmount, 
      String? conversionRate, 
      String? baseCurrencyRate, 
      Sender? sender, 
      Recipient? recipient, 
      String? sourceOfFundId, 
      String? sendingPurposeId, 
      dynamic verificationCode, 
      String? verificationTime, 
      String? payoutBy, 
      String? paymentStatus, 
      String? status, 
      dynamic adminFeedback, 
      dynamic receivedAt, 
      String? createdAt, 
      String? updatedAt, 
      Deposit? deposit, 
      RecipientCountry? recipientCountry, 
      CountryDeliveryMethod? countryDeliveryMethod,}){
    _id = id;
    _mtcnNumber = mtcnNumber;
    _trx = trx;
    _countryDeliveryMethodId = countryDeliveryMethodId;
    _serviceId = serviceId;
    _userId = userId;
    _agentId = agentId;
    _serviceFormData = serviceFormData;
    _baseCurrencyAmount = baseCurrencyAmount;
    _baseCurrencyCharge = baseCurrencyCharge;
    _sendingCountryId = sendingCountryId;
    _sendingCurrency = sendingCurrency;
    _sendingAmount = sendingAmount;
    _sendingCharge = sendingCharge;
    _recipientCountryId = recipientCountryId;
    _recipientCurrency = recipientCurrency;
    _recipientAmount = recipientAmount;
    _conversionRate = conversionRate;
    _baseCurrencyRate = baseCurrencyRate;
    _sender = sender;
    _recipient = recipient;
    _sourceOfFundId = sourceOfFundId;
    _sendingPurposeId = sendingPurposeId;
    _verificationCode = verificationCode;
    _verificationTime = verificationTime;
    _payoutBy = payoutBy;
    _paymentStatus = paymentStatus;
    _status = status;
    _adminFeedback = adminFeedback;
    _receivedAt = receivedAt;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
    _deposit = deposit;
    _recipientCountry = recipientCountry;
    _countryDeliveryMethod = countryDeliveryMethod;
}

  Data.fromJson(dynamic json) {
    _id = json['id'];
    _mtcnNumber = json['mtcn_number'] ?? '';
    _trx = json['trx'];
    _countryDeliveryMethodId = json['country_delivery_method_id'].toString();
    _serviceId = json['service_id'].toString();
    _userId = json['user_id'].toString();
    _agentId = json['agent_id'].toString();
    _serviceFormData = json['service_form_data'] != null ? json['service_form_data'].toString() : '';
    _baseCurrencyAmount = json['base_currency_amount'] != null ? json['base_currency_amount'].toString() : '';
    _baseCurrencyCharge = json['base_currency_charge'] != null ? json['base_currency_charge'].toString() : '';
    _sendingCountryId = json['sending_country_id'] != null ? json['sending_country_id'].toString() : '';
    _sendingCurrency = json['sending_currency'] != null ? json['sending_currency'].toString() : '';
    _sendingAmount = json['sending_amount'] != null ? json['sending_amount'].toString() : '';
    _sendingCharge = json['sending_charge'] != null ? json['sending_charge'].toString() : '';
    _recipientCountryId = json['recipient_country_id'] != null ? json['recipient_country_id'].toString() : '';
    _recipientCurrency = json['recipient_currency'] != null ? json['recipient_currency'].toString() : '';
    _recipientAmount = json['recipient_amount'] != null ? json['recipient_amount'].toString() : '';
    _conversionRate = json['conversion_rate'] != null ? json['conversion_rate'].toString() : '';
    _baseCurrencyRate = json['base_currency_rate'] != null ? json['base_currency_rate'].toString() : '';
    _sender = json['sender'] != null ? Sender.fromJson(json['sender']) : null;
    _recipient = json['recipient'] != null ? Recipient.fromJson(json['recipient']) : null;
    _sourceOfFundId = json['source_of_fund_id'] != null ? json['source_of_fund_id'].toString() : '';
    _sendingPurposeId = json['sending_purpose_id'] != null ? json['sending_purpose_id'].toString() : '';
    _verificationCode = json['verification_code'] != null ? json['verification_code'].toString() : '';
    _verificationTime = json['verification_time'] != null ? json['verification_time'].toString() : '';
    _payoutBy = json['payout_by'] != null ? json['payout_by'].toString() : '';
    _paymentStatus = json['payment_status'] != null ? json['payment_status'].toString() : '';
    _status = json['status'] != null ? json['status'].toString() : '';
    _adminFeedback = json['admin_feedback'].toString();
    _receivedAt = json['received_at'];
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
    _deposit = json['deposit'] != null ? Deposit.fromJson(json['deposit']) : null;
    _recipientCountry = json['recipient_country'] != null ? RecipientCountry.fromJson(json['recipient_country']) : null;
    _countryDeliveryMethod = json['country_delivery_method'] != null ? CountryDeliveryMethod.fromJson(json['country_delivery_method']) : null;
  }
  int? _id;
  String? _mtcnNumber;
  String? _trx;
  String? _countryDeliveryMethodId;
  String? _serviceId;
  String? _userId;
  String? _agentId;
  dynamic _serviceFormData;
  String? _baseCurrencyAmount;
  String? _baseCurrencyCharge;
  String? _sendingCountryId;
  String? _sendingCurrency;
  String? _sendingAmount;
  String? _sendingCharge;
  String? _recipientCountryId;
  String? _recipientCurrency;
  String? _recipientAmount;
  String? _conversionRate;
  String? _baseCurrencyRate;
  Sender? _sender;
  Recipient? _recipient;
  String? _sourceOfFundId;
  String? _sendingPurposeId;
  dynamic _verificationCode;
  String? _verificationTime;
  String? _payoutBy;
  String? _paymentStatus;
  String? _status;
  dynamic _adminFeedback;
  dynamic _receivedAt;
  String? _createdAt;
  String? _updatedAt;
  Deposit? _deposit;
  RecipientCountry? _recipientCountry;
  CountryDeliveryMethod? _countryDeliveryMethod;

  int? get id => _id;
  String? get mtcnNumber => _mtcnNumber;
  String? get trx => _trx;
  String? get countryDeliveryMethodId => _countryDeliveryMethodId;
  String? get serviceId => _serviceId;
  String? get userId => _userId;
  String? get agentId => _agentId;
  dynamic get serviceFormData => _serviceFormData;
  String? get baseCurrencyAmount => _baseCurrencyAmount;
  String? get baseCurrencyCharge => _baseCurrencyCharge;
  String? get sendingCountryId => _sendingCountryId;
  String? get sendingCurrency => _sendingCurrency;
  String? get sendingAmount => _sendingAmount;
  String? get sendingCharge => _sendingCharge;
  String? get recipientCountryId => _recipientCountryId;
  String? get recipientCurrency => _recipientCurrency;
  String? get recipientAmount => _recipientAmount;
  String? get conversionRate => _conversionRate;
  String? get baseCurrencyRate => _baseCurrencyRate;
  Sender? get sender => _sender;
  Recipient? get recipient => _recipient;
  String? get sourceOfFundId => _sourceOfFundId;
  String? get sendingPurposeId => _sendingPurposeId;
  dynamic get verificationCode => _verificationCode;
  String? get verificationTime => _verificationTime;
  String? get payoutBy => _payoutBy;
  String? get paymentStatus => _paymentStatus;
  String? get status => _status;
  dynamic get adminFeedback => _adminFeedback;
  dynamic get receivedAt => _receivedAt;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;
  Deposit? get deposit => _deposit;
  RecipientCountry? get recipientCountry => _recipientCountry;
  CountryDeliveryMethod? get countryDeliveryMethod => _countryDeliveryMethod;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['mtcn_number'] = _mtcnNumber;
    map['trx'] = _trx;
    map['country_delivery_method_id'] = _countryDeliveryMethodId;
    map['service_id'] = _serviceId;
    map['user_id'] = _userId;
    map['agent_id'] = _agentId;
    map['service_form_data'] = _serviceFormData;
    map['base_currency_amount'] = _baseCurrencyAmount;
    map['base_currency_charge'] = _baseCurrencyCharge;
    map['sending_country_id'] = _sendingCountryId;
    map['sending_currency'] = _sendingCurrency;
    map['sending_amount'] = _sendingAmount;
    map['sending_charge'] = _sendingCharge;
    map['recipient_country_id'] = _recipientCountryId;
    map['recipient_currency'] = _recipientCurrency;
    map['recipient_amount'] = _recipientAmount;
    map['conversion_rate'] = _conversionRate;
    map['base_currency_rate'] = _baseCurrencyRate;
    if (_sender != null) {
      map['sender'] = _sender?.toJson();
    }
    if (_recipient != null) {
      map['recipient'] = _recipient?.toJson();
    }
    map['source_of_fund_id'] = _sourceOfFundId;
    map['sending_purpose_id'] = _sendingPurposeId;
    map['verification_code'] = _verificationCode;
    map['verification_time'] = _verificationTime;
    map['payout_by'] = _payoutBy;
    map['payment_status'] = _paymentStatus;
    map['status'] = _status;
    map['admin_feedback'] = _adminFeedback;
    map['received_at'] = _receivedAt;
    map['created_at'] = _createdAt;
    map['updated_at'] = _updatedAt;
    if (_deposit != null) {
      map['deposit'] = _deposit?.toJson();
    }
    if (_recipientCountry != null) {
      map['recipient_country'] = _recipientCountry?.toJson();
    }
    if (_countryDeliveryMethod != null) {
      map['country_delivery_method'] = _countryDeliveryMethod?.toJson();
    }
    return map;
  }

}

class CountryDeliveryMethod {
  CountryDeliveryMethod({
      int? id, 
      String? countryId, 
      String? deliveryMethodId, 
      DeliveryMethod? deliveryMethod,}){
    _id = id;
    _countryId = countryId;
    _deliveryMethodId = deliveryMethodId;
    _deliveryMethod = deliveryMethod;
}

  CountryDeliveryMethod.fromJson(dynamic json) {
    _id = json['id'];
    _countryId = json['country_id'].toString();
    _deliveryMethodId = json['delivery_method_id'].toString();
    _deliveryMethod = json['delivery_method'] != null ? DeliveryMethod.fromJson(json['delivery_method']) : null;
  }
  int? _id;
  String? _countryId;
  String? _deliveryMethodId;
  DeliveryMethod? _deliveryMethod;

  int? get id => _id;
  String? get countryId => _countryId;
  String? get deliveryMethodId => _deliveryMethodId;
  DeliveryMethod? get deliveryMethod => _deliveryMethod;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['country_id'] = _countryId;
    map['delivery_method_id'] = _deliveryMethodId;
    if (_deliveryMethod != null) {
      map['delivery_method'] = _deliveryMethod?.toJson();
    }
    return map;
  }

}

class DeliveryMethod {
  DeliveryMethod({
      int? id, 
      String? name, 
      String? status, 
      String? createdAt, 
      String? updatedAt,}){
    _id = id;
    _name = name;
    _status = status;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
}

  DeliveryMethod.fromJson(dynamic json) {
    _id = json['id'];
    _name = json['name'] ?? '';
    _status = json['status'].toString();
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
  }
  int? _id;
  String? _name;
  String? _status;
  String? _createdAt;
  String? _updatedAt;

  int? get id => _id;
  String? get name => _name;
  String? get status => _status;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['name'] = _name;
    map['status'] = _status;
    map['created_at'] = _createdAt;
    map['updated_at'] = _updatedAt;
    return map;
  }

}

class RecipientCountry {
  RecipientCountry({
      int? id, 
      String? name, 
      String? countryCode, 
      String? dialCode, 
      String? currency, 
      String? rate, 
      String? image, 
      String? isSending, 
      String? isReceiving, 
      String? hasAgent, 
      String? status, 
      String? createdAt, 
      String? updatedAt,}){
    _id = id;
    _name = name;
    _countryCode = countryCode;
    _dialCode = dialCode;
    _currency = currency;
    _rate = rate;
    _image = image;
    _isSending = isSending;
    _isReceiving = isReceiving;
    _hasAgent = hasAgent;
    _status = status;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
}

  RecipientCountry.fromJson(dynamic json) {
    _id = json['id'];
    _name = json['name'] ?? '';
    _countryCode = json['country_code'] != null ? json['country_code'].toString() : '';
    _dialCode = json['dial_code'];
    _currency = json['currency'] != null ? json['currency'].toString() : '';
    _rate = json['rate'] != null ? json['rate'].toString() : '';
    _image = json['image'].toString();
    _isSending = json['is_sending'].toString();
    _isReceiving = json['is_receiving'].toString();
    _hasAgent = json['has_agent']!= null ? json['has_agent'].toString() : '';
    _status = json['status'].toString();
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
  }
  int? _id;
  String? _name;
  String? _countryCode;
  String? _dialCode;
  String? _currency;
  String? _rate;
  String? _image;
  String? _isSending;
  String? _isReceiving;
  String? _hasAgent;
  String? _status;
  String? _createdAt;
  String? _updatedAt;

  int? get id => _id;
  String? get name => _name;
  String? get countryCode => _countryCode;
  String? get dialCode => _dialCode;
  String? get currency => _currency;
  String? get rate => _rate;
  String? get image => _image;
  String? get isSending => _isSending;
  String? get isReceiving => _isReceiving;
  String? get hasAgent => _hasAgent;
  String? get status => _status;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['name'] = _name;
    map['country_code'] = _countryCode;
    map['dial_code'] = _dialCode;
    map['currency'] = _currency;
    map['rate'] = _rate;
    map['image'] = _image;
    map['is_sending'] = _isSending;
    map['is_receiving'] = _isReceiving;
    map['has_agent'] = _hasAgent;
    map['status'] = _status;
    map['created_at'] = _createdAt;
    map['updated_at'] = _updatedAt;
    return map;
  }

}

class Deposit {
  Deposit({
      int? id, 
      String? userId, 
      String? agentId, 
      String? sendMoneyId, 
      String? methodCode, 
      String? amount, 
      String? methodCurrency, 
      String? charge, 
      String? rate, 
      String? finalAmo, 
      String? btcAmo, 
      String? btcWallet, 
      String? trx, 
      String? paymentTry, 
      String? status, 
      String? fromApi, 
      dynamic adminFeedback, 
      String? createdAt, 
      String? updatedAt, 
      Gateway? gateway,}){
    _id = id;
    _userId = userId;
    _agentId = agentId;
    _sendMoneyId = sendMoneyId;
    _methodCode = methodCode;
    _amount = amount;
    _methodCurrency = methodCurrency;
    _charge = charge;
    _rate = rate;
    _finalAmo = finalAmo;
    _btcAmo = btcAmo;
    _btcWallet = btcWallet;
    _trx = trx;
    _paymentTry = paymentTry;
    _status = status;
    _fromApi = fromApi;
    _adminFeedback = adminFeedback;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
    _gateway = gateway;
}

  Deposit.fromJson(dynamic json) {
    _id = json['id'];
    _userId = json['user_id'].toString();
    _agentId = json['agent_id'].toString();
    _sendMoneyId = json['send_money_id'].toString();
    _methodCode = json['method_code'] != null ? json['method_code'].toString() : '';
    _amount = json['amount'] != null ? json['amount'].toString() : '';
    _methodCurrency = json['method_currency'] != null ? json['method_currency'].toString() : '';
    _charge = json['charge'] != null ? json['charge'].toString() : '';
    _rate = json['rate'] != null ? json['rate'].toString() : '';
    _finalAmo = json['final_amo'] != null ? json['final_amo'].toString() : '';
    _btcAmo = json['btc_amo'] != null ? json['btc_amo'].toString() : '';
    _btcWallet = json['btc_wallet'] != null ? json['btc_wallet'].toString() : '';
    _trx = json['trx'] != null ? json['trx'].toString() : '';
    _paymentTry = json['payment_try'] != null ? json['payment_try'].toString() : '';
    _status = json['status'].toString();
    _fromApi = json['from_api'] != null ? json['from_api'].toString() : '';
    _adminFeedback = json['admin_feedback'].toString();
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
    _gateway = json['gateway'] != null ? Gateway.fromJson(json['gateway']) : null;
  }
  int? _id;
  String? _userId;
  String? _agentId;
  String? _sendMoneyId;
  String? _methodCode;
  String? _amount;
  String? _methodCurrency;
  String? _charge;
  String? _rate;
  String? _finalAmo;
  String? _btcAmo;
  String? _btcWallet;
  String? _trx;
  String? _paymentTry;
  String? _status;
  String? _fromApi;
  dynamic _adminFeedback;
  String? _createdAt;
  String? _updatedAt;
  Gateway? _gateway;

  int? get id => _id;
  String? get userId => _userId;
  String? get agentId => _agentId;
  String? get sendMoneyId => _sendMoneyId;
  String? get methodCode => _methodCode;
  String? get amount => _amount;
  String? get methodCurrency => _methodCurrency;
  String? get charge => _charge;
  String? get rate => _rate;
  String? get finalAmo => _finalAmo;
  String? get btcAmo => _btcAmo;
  String? get btcWallet => _btcWallet;
  String? get trx => _trx;
  String? get paymentTry => _paymentTry;
  String? get status => _status;
  String? get fromApi => _fromApi;
  dynamic get adminFeedback => _adminFeedback;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;
  Gateway? get gateway => _gateway;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['user_id'] = _userId;
    map['agent_id'] = _agentId;
    map['send_money_id'] = _sendMoneyId;
    map['method_code'] = _methodCode;
    map['amount'] = _amount;
    map['method_currency'] = _methodCurrency;
    map['charge'] = _charge;
    map['rate'] = _rate;
    map['final_amo'] = _finalAmo;
    map['btc_amo'] = _btcAmo;
    map['btc_wallet'] = _btcWallet;
    map['trx'] = _trx;
    map['payment_try'] = _paymentTry;
    map['status'] = _status;
    map['from_api'] = _fromApi;
    map['admin_feedback'] = _adminFeedback;
    map['created_at'] = _createdAt;
    map['updated_at'] = _updatedAt;
    if (_gateway != null) {
      map['gateway'] = _gateway?.toJson();
    }
    return map;
  }

}

class Gateway {
  Gateway({
      int? id, 
      String? formId, 
      String? code, 
      String? name, 
      String? alias, 
      String? status,
      String? crypto, 
      dynamic description, 
      String? createdAt, 
      String? updatedAt,}){
    _id = id;
    _formId = formId;
    _code = code;
    _name = name;
    _alias = alias;
    _status = status;
    _crypto = crypto;
    _description = description;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
}

  Gateway.fromJson(dynamic json) {
    _id = json['id'];
    _formId = json['form_id'].toString();
    _code = json['code'].toString();
    _name = json['name'] ?? '';
    _alias = json['alias'].toString();
    _status = json['status'].toString();
    _crypto = json['crypto'].toString();
    _description = json['description'];
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
  }
  int? _id;
  String? _formId;
  String? _code;
  String? _name;
  String? _alias;
  String? _status;
  String? _crypto;
  dynamic _description;
  String? _createdAt;
  String? _updatedAt;

  int? get id => _id;
  String? get formId => _formId;
  String? get code => _code;
  String? get name => _name;
  String? get alias => _alias;
  String? get status => _status;
  String? get crypto => _crypto;
  dynamic get description => _description;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['form_id'] = _formId;
    map['code'] = _code;
    map['name'] = _name;
    map['alias'] = _alias;
    map['status'] = _status;
    map['crypto'] = _crypto;
    map['description'] = _description;
    map['created_at'] = _createdAt;
    map['updated_at'] = _updatedAt;
    return map;
  }

}

class Recipient {
  Recipient({
      String? name, 
      String? mobile, 
      String? email, 
      String? address,}){
    _name = name;
    _mobile = mobile;
    _email = email;
    _address = address;
}

  Recipient.fromJson(dynamic json) {
    _name = json['name'] ?? '';
    _mobile = json['mobile'].toString();
    _email = json['email'] ?? '';
    _address = json['address'] ?? '';
  }

  String? _name;
  String? _mobile;
  String? _email;
  String? _address;

  String? get name => _name;
  String? get mobile => _mobile;
  String? get email => _email;
  String? get address => _address;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['name'] = _name;
    map['mobile'] = _mobile;
    map['email'] = _email;
    map['address'] = _address;
    return map;
  }

}

class Sender {
  Sender({
      String? mobile, 
      dynamic email, 
      dynamic address,}){
    _mobile = mobile;
    _email = email;
    _address = address;
}

  Sender.fromJson(dynamic json) {
    _mobile = json['mobile'] ?? '';
    _email = json['email'] ?? '';
    _address = json['address'] ?? '';
  }
  String? _mobile;
  dynamic _email;
  dynamic _address;

  String? get mobile => _mobile;
  dynamic get email => _email;
  dynamic get address => _address;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['mobile'] = _mobile;
    map['email'] = _email;
    map['address'] = _address;
    return map;
  }

}